<?php
/*#################################################################################
	AdLogger
	- An open-source tracking tool for preventing click fraud

	Copyright 2006 by Trevor Fitzgerald
	http://www.adlogger.org

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

	If you find this script useful, please share it with others!

	Thank you!
*/#################################################################################

/*
The micro_time function times how long it takes to load each page
in the administration panel.  The value is shown in the footer of
each page.  The micro_time function is called twice per page: once
at the beginning, then again at the end.  At the end, it takes the
difference of those two values and determines the amount of time
between them.
*/
function micro_time($start_time) {
	list($usec, $sec) = explode(" ", microtime());
	$micro_time = ((float)$usec + (float)$sec);

	if ($start_time == 0) {
		return $micro_time;
	} else {
		$total_time = $micro_time - $start_time;
		return $total_time;
	}
}

/*
The bodyHeader function is used to start the HTML output.  It also
checks to see which page it's being used on to determine what
stylesheets and scripts to include.
*/
function bodyHeader($page, $version_num) { ?>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN" "http://www.w3.org/TR/html4/loose.dtd">
<html>
	<head>
			<meta http-equiv="content-type" content="text/html; charset=UTF-8">
			<meta name="description" content="AdLogger Version <?php echo $version_num; ?>">
			<link rel="stylesheet" type="text/css" media="screen" href="<?php if ($page == 'install') echo "../admin/"; ?>styles/main_stylesheet.css">
			<link rel="stylesheet" type="text/css" media="screen" href="<?php if ($page == 'install') echo "../admin/"; ?>styles/form_styles.css">
		<?php if (($page == 'archive') || ($page == 'rankings')) { ?>
			<link href="./styles/popup_calendar.css" rel="stylesheet" media="screen" type="text/css">
		<?php }
		if ($page == 'install') { ?>
			<title>AdLogger Install</title>
		<?php } else { ?>
			<title>AdLogger Admin</title>
		<?php }
		if ($page == 'settings') { ?>
			<script type="text/javascript" src="./scripts/confirm.js"></script>
			<script type="text/javascript" src="./scripts/settings.js"></script>
		<?php } elseif ($page == 'click_info') { ?>
			<script type="text/javascript" src="./scripts/confirm.js"></script>
		<?php } elseif ($page == 'archive') { ?>
			<script type="text/javascript" src="./scripts/archive.js"></script>
			<script type="text/javascript" src="./scripts/popup_calendar.js"></script>
		<?php } elseif ($page == 'install') { ?>
			<script type="text/javascript" src="./scripts/install.js"></script>
		<?php } elseif ($page == 'rankings') { ?>
			<script type="text/javascript" src="./scripts/rankings.js"></script>
			<script type="text/javascript" src="./scripts/popup_calendar.js"></script>
		<?php } ?>
	</head>
<?php }

/*
The bodyNavigation function outputs the navigation bar for each of the admin pages.
*/
function bodyNavigation($page) {
	// If the page is the Login page, automatically focus the cursor to the username box
	if ($page == 'login') {
		echo '<body onload="document.getElementById(\'loginbox\').focus();">';
	} else {
		echo '<body>';
	}
	?>
		<div id="header">
			<div class="superHeader">
				<div class="right">
					<?php if (($page != 'install') && ($page != 'login')) { ?> | <a href="./logout.php">Logout</a> | <?php } ?>
				</div>
			</div>
			<div class="midHeader">
				<?php if ($page == 'install') { ?>
				<h1 class="headerTitle">AdLogger Installation</h1>
				<?php } else { ?>
				<h1 class="headerTitle">AdLogger Administration</h1>
				<?php } ?>
			</div>
			<div class="subHeader"><?php if ($page != 'install') { ?><span class="doNotDisplay">Navigation:</span> <a href="./">Overview</a> | <a href="./all_clicks.php">All Clicks</a> | <a href="./archive.php">Archive Data</a> | <a href="./rankings.php">Rankings</a> | <a href="./block_info.php">Block Info</a> | <a href="./code_gen.php">AdLogger Setup</a>| <a href="./manage.php">Manage</a> | <a href="./support.php">Support</a><?php if (file_exists("./data_gen.php")) { echo " | <a href=\"./data_gen.php\">Data Generator</a>"; } } ?></div>

			<?php if ($page == 'code_gen') { ?><div class="subsubHeader"><span class="doNotDisplay">Navigation:</span> <a href="./code_gen.php?tracking">Tracking Code</a> | <a href="./code_gen.php?wrapping">Wrapping Code</a> | <a href="./code_gen.php?cache_control">Cache-Control Code</a> | </div>

			<?php } elseif ($page == 'settings') { ?><div class="subsubHeader"><span class="doNotDisplay">Navigation:</span> <a href="./manage.php?settings">Settings &amp; Preferences</a> | <a href="./manage.php?channels">Channels</a> | <a href="./manage.php?logs">Log Files</a> | <a href="./manage.php?accounts">Accounts</a> | <a href="./manage.php?info">Script Info</a> | </div>

			<?php } ?>
		</div>
<?php }

/*
The bodyFooter function outputs the closing HTML code for each of the admin pages.
*/
function bodyFooter($page, $start_time) { ?>
		<div id="footer">
			<div class="left">Page generated in <?php echo micro_time($start_time); ?> seconds.<br /><a href="http://www.adlogger.org/index.php/Main_Page" title="AdLogger - Click Fraud Prevention">http://www.adlogger.org/</a></div>
			<div class="right">Copyright &copy; 2006 <a href="http://www.adlogger.org/index.php/Main_Page" title="AdLogger - Click Fraud Monitoring">AdLogger</a> and <a href="http://www.trevorfitzgerald.com/" title="Trevor Fitzgerald">Trevor Fitzgerald</a>. All rights reserved.<br />AdLogger is provided under the GNU General Public License.</div>
		</div>
	</body>
</html><?php }

// Function to determine an IP address
function visitorIP() {
	if (getenv("REMOTE_ADDR")) {
		$ip = getenv("REMOTE_ADDR");
	} else {
		$ip = $_SERVER['REMOTE_ADDR'];
	}

	$ip = mysql_real_escape_string(htmlentities($ip));
	return $ip;
}

/*
Sometimes URLs are way too long and can screw up a table layout by running over.
This solves that by automatically truncating the middle part of a long URL.
Ex: http://www.abcdefghijklmnopqrstuvwxyz.com can become http://www.abc...xyz.com
It also determines if a value exists for the given URL.
If it's blank, it returns "Unknown".
*/
function shortenURL($originalLink) {
	if (strlen($originalLink) > 55) {
		$shortenlink = substr($originalLink, 0, 18) . '...' . substr($originalLink, -32);
		return '<a href = "http://' . $originalLink . '" title = "' . $originalLink . '" target="_blank">' . $shortenlink . '</a>';
	} elseif (empty($originalLink)) {
		$shortenlink = "<em>Unknown</em>";
		return $shortenlink;
	} else {
		return '<a href = "http://' . $originalLink . '" title = "' . $originalLink . '" target="_blank">' . $originalLink . '</a>';
	}
}

/*
If a value is empty, have it say "N/A" rather than leaving it blank.
*/
function unset_if_string_empty($originalString) {
	if (!empty($originalString)) {
		return $originalString;
	} else {
		return "<em>N/A</em>";
	}
}

/*
Verify that a given file is able to be written to via the script.
*/
function check_permissions($filename) {
    $chmod = substr(sprintf('%o', fileperms($filename)), -4);
    if ((!is_writable($filename)) || (substr($chmod,2) == "44")) {
        return true;
    }
}

/*
This is used on the Settings page.  If config_settings.php isn't writable,
don't let the user edit any of the field values.
*/
function disable_if_not_writable() {
	if (check_permissions('../config_settings.php')) {
		echo 'disabled="disabled" ';
	}
}

/*
 * Automatically select a certain item from the dropdown if
 * it's supposed to be selected.
 */
function select_item_if_chosen($item, $chosen) {
	if ($item == $chosen) {
		echo 'selected="selected"';
	}
}

/*
Verify that a connection to the database has been made.
If it hasn't, produce an error.
*/
function check_db_connection($adlogger_db_connect, $adlogger_db_select) {
	if (!$adlogger_db_connect) {
		echo "<div id=\"main-copy\">" .
				"<h1>Error!</h1>" .
				"<p>AdLogger can't seem to connect to the database. This could be caused by one of two things:</p>" .
				"<ul>" .
					"<li>The database server is down.</li>" .
					"<li>The database credentials changed (username/password/priveleges)</li>" .
				"</ul>" .
			"</div>";
		bodyFooter('error', $start_time);
		exit();
	} elseif (!$adlogger_db_select) {
		echo "<div id=\"main-copy\">" .
				"<h1>Error!</h1>" .
				"<p>AdLogger can't seem to select the proper database. It can connect to the database server just fine, but can't access the AdLogger database.</p>" .
				"<ul>" .
					"<li>Does the database still exist?</li>" .
				"</ul>" .
			"</div>";
		bodyFooter('error', $start_time);
		exit();
	}
}

/*
Validate that a given IP address is actually valid.
*/
function valid_ip($ip) {
	$ip = explode(".", $ip);
		if (count($ip)!= 4) {
			return false;
		}
		foreach ($ip as $block) {
			if (!is_numeric($block) || $block > 255 || $block < 1) {
				return false;
			}
		}
	return true;
}

/*
Validate that an IP entered in the banned list is valid
as either an IP address or IP range.
*/
function valid_ip_range($ip) {
	if (empty($ip)) {
		return true;
	}
	$ip_parts = explode(".", $ip);
		if (empty($ip_parts[0])) {
			return false;
		}
		if (count($ip_parts) > 4) {
			return false;
		}
		foreach ($ip_parts as $block) {
			if (!empty($block) && (!is_numeric($block) || $block > 255 || $block < 1)) {
				return false;
			}
		}
	return true;
}

/*
Validate an email address to the correct format.
*/
function is_valid_email($email) {
  if(!eregi("^[_a-z0-9-]+(\.[_a-z0-9-]+)*@[a-z0-9-]+(\.[a-z0-9-]+)*(\.[a-z]{2,4})$", $email)) {
    return false;
  } else {
  	return true;
  }
}

/*
Create a random string of characters of a given length.
This is used on the Password Reset to create a new password for the administrator.
Also, it's used during the installation to create a "login_hash".  That login hash is
unique to each person's installation of AdLogger.  It's used as the value for "Remember Me"
and the Session.
*/
function createRandomString($characters) {
	$chars = "abcdefghijkmnpqrstuvwxyz23456789ABCDEFGHJKLMNPQRSTUVWXYZ";
	srand((double)microtime()*1000000);
	$i = 1;
	$pass = '';
	while ($i <= $characters) {
		$num = rand() % 56;
		$tmp = substr($chars, $num, 1);
		$pass = $pass . $tmp;
		$i++;
	}
	return $pass;
}

/*
 * In an effort to increase my search engine performance,
 * the javascript code generator attaches a random keyword
 * to the copyright notice and the URL inside it.
 */
function adlogger_keywords() {
	$keywords = array("Click Fraud Protection", "Click Auditing", "Click Fraud Detection", "Click Fraud Tracking", "PPC Click Fraud", "Detect Click Fraud", "Click Fraud Monitoring", "Click Fraud", "AdSense Tracking", "AdSense Tracker", "Yahoo Publisher Network Tracker", "Yahoo Publisher Network Tracking", "Click Fraud Tracker", "Prevent Click Fraud");
	$rand_keyword = array_rand($keywords);
	echo $keywords[$rand_keyword];
}

/*
 * Convert bytes to something more useable.
 * Used on the Settings page when displaying the database size.
 */
function convert_bytes($db_size_bytes = 0) {

	if ($db_size_bytes > 1073741824 ) {
		$db_size = round($db_size_bytes/1073741824,1) . ' GB';
	} elseif ($db_size_bytes > 1048576 ) {
		$db_size = round($db_size_bytes/1048576,1) . ' MB';
	} elseif ($db_size_bytes > 1024 ) {
		$db_size = round($db_size_bytes/1024,1) . ' KB';
	} elseif ($db_size_bytes >= 0 ) {
		$db_size = $db_size_bytes . ' Bytes';
	}

	return $db_size;
}

/*
 * Calcuate the time for a given timezone.
 * Used on the Settings page in the timezone dropdown to
 * make it easier to figure out your timezone.
 */
function time_change($dif) {
	$time = date('g:i a, m/j/y', time()+(60*60*$dif));
	echo $time;
}

/*
 * Convert the hour from the 24 hour scale to the 12 for the rankings page
 */
function convertHour($hour) {
	return date('ga', mktime($hour, 0, 0, 10, 25, 1986));
}

/*
 * This converts the AdSense ad format into something we can use.
 */
function convertAdFormat($ad_format, $side) {
	$dimensions = explode('x', $ad_format);
	if ($side == 'width') {
		$ad_width = $dimensions[0];
		return $ad_width;
	} elseif ($side == 'height') {
		$ad_height = explode('_', $dimensions[1]);
		$ad_height = $ad_height[0];
		return $ad_height;
	}
}

/*
 * Tells what type of ad was clicked (ad or link unit)
 */
function translateAdFormat($ad_format) {
	if (strstr($ad_format, '_as')) {
		return 'Ad Unit';
	} elseif (strstr($ad_format, '_0ads_al_s')) {
		return 'Link Unit (5x)';
	} elseif (strstr($ad_format, '_0ads_al')) {
		return 'Link Unit (4x)';
	} else {
		return '<em>Unknown Format</em>';
	}
}

/*
 * Determine if the script should try to draw the color.
 * If it should, go ahead and draw it.
 */
function draw_color($hex, $gd_enabled) {
	if ($gd_enabled && !empty($hex)) {
		return '<br /><img src="./draw_color.php?hex=' . $hex . '" alt="' . $hex . ' " border="0" />';
	}
}

// Convert seconds to minutes
function seconds2minutes($seconds) {
	$minutes = intval($seconds / 60);
		if ($minutes == 1) {
			$output = $minutes . " min ";
		} else {
			$output = $minutes . " mins ";
		}
	$seconds = $seconds % 60;
		if ($seconds == 1) {
			$output .= $seconds . " sec ";
		} else {
			$output .= $seconds . " secs ";
		}
	return $output;
}
?>